// Borland C++ Builder
// Copyright (c) 1995, 2002 by Borland Software Corporation
// All rights reserved

// (DO NOT EDIT: machine generated header) 'ZylCustomGPSReceiver.pas' rev: 6.00

#ifndef ZylCustomGPSReceiverHPP
#define ZylCustomGPSReceiverHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <DateUtils.hpp>	// Pascal unit
#include <Dialogs.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Zylcustomgpsreceiver
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TCardinalPoint { cpNorth, cpSouth, cpEast, cpWest };
#pragma option pop

#pragma option push -b-
enum TDirection { dirForward, dirLeft, dirRight };
#pragma option pop

#pragma option push -b-
enum ZylCustomGPSReceiver__1 { GPAAM, GPBWC, GPGGA, GPGLL, GPMSS, GPRMB, GPRMC, GPGSA, GPGSV, GPVTG, GPZDA };
#pragma option pop

typedef Set<ZylCustomGPSReceiver__1, GPAAM, GPZDA>  TNMEACommands;

typedef void __fastcall (__closure *TParamChangeEvent)(System::TObject* Sender, Extended Value);

typedef void __fastcall (__closure *TPositionChangeEvent)(System::TObject* Sender, int Degree, int Minute, Extended Second, TCardinalPoint Direction);

typedef void __fastcall (__closure *TShortPositionChangeEvent)(System::TObject* Sender, Extended Latitude, Extended Longitude);

typedef void __fastcall (__closure *TShortPosition3DChangeEvent)(System::TObject* Sender, Extended Latitude, Extended Longitude, Extended Altitude);

typedef void __fastcall (__closure *TArrivalEvent)(System::TObject* Sender, AnsiString Waypoint, Extended CircleRadius);

class DELPHICLASS TReceiverStatus;
class PASCALIMPLEMENTATION TReceiverStatus : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	Extended SignalStrength;
	Extended SNR;
	Extended Frequency;
	Extended DataRate;
	__fastcall TReceiverStatus(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TReceiverStatus(void) { }
	#pragma option pop
	
};


class DELPHICLASS TSatellite;
class PASCALIMPLEMENTATION TSatellite : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int PseudoRandomCode;
	int Azimuth;
	int Elevation;
	int SignalToNoiseRatio;
	__fastcall TSatellite(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TSatellite(void) { }
	#pragma option pop
	
};


class DELPHICLASS TNavigationInfo;
class PASCALIMPLEMENTATION TNavigationInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	AnsiString Origin;
	AnsiString Destination;
	Extended RangeToDestination;
	Extended TrueBearingToDestination;
	Extended MagneticBearingToDestination;
	Extended VelocityTowardsDestination;
	Extended CrossTrackError;
	TDirection DirectionToSteer;
	__fastcall TNavigationInfo(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TNavigationInfo(void) { }
	#pragma option pop
	
};


typedef void __fastcall (__closure *TSatelliteReceiveEvent)(System::TObject* Sender, TSatellite* Satellite);

class DELPHICLASS TGPSPosition;
class PASCALIMPLEMENTATION TGPSPosition : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int Latitude_Degree;
	int Latitude_Minute;
	Extended Latitude_Second;
	TCardinalPoint Latitude_Direction;
	int Longitude_Degree;
	int Longitude_Minute;
	Extended Longitude_Second;
	TCardinalPoint Longitude_Direction;
	Extended Altitude;
	Extended Heading;
	Extended Speed_Knots;
	Extended Speed_KMH;
	Extended Magnetic_Variation;
	Extended Magnetic_Heading;
	TCardinalPoint Declination;
	Word Day;
	Word Month;
	Word Year;
	Word Hour;
	Word Minute;
	Word Second;
	Word Millisecond;
	Word Satellite_Count;
	Extended PDOP;
	Extended HDOP;
	Extended VDOP;
	Extended Geo_Height;
	Word Fix;
	Word Mode1;
	Word Mode2;
	Classes::TList* Satellites;
	__fastcall TGPSPosition(void);
	__fastcall virtual ~TGPSPosition(void);
};


class DELPHICLASS TZylCustomGPSReceiver;
class PASCALIMPLEMENTATION TZylCustomGPSReceiver : public Classes::TComponent 
{
	typedef Classes::TComponent inherited;
	
private:
	bool FRegistered;
	AnsiString FData;
	AnsiString FDelayedData;
	TGPSPosition* FPosition;
	TReceiverStatus* FReceiverStatus;
	TNavigationInfo* FNavigationInfo;
	bool FForceCheckSum;
	bool FNMEALog;
	TNMEACommands FCommands;
	double FVersion;
	bool __fastcall IsValidCommand(AnsiString strNMEA);
	Classes::TStringList* __fastcall ExtractCommands(AnsiString strNMEA);
	void __fastcall ExtractPosition(AnsiString strNMEA);
	bool __fastcall ExtractCoord(AnsiString strLt, Word &lDegree, Word &lMinute, Extended &lSecond);
	bool __fastcall ExtractUTCTime(AnsiString strUTC, Word &uHour, Word &uMinute, Word &uSecond, Word &uMSecond);
	bool __fastcall ExtractUTCDate(AnsiString strDate, Word &dYear, Word &dMonth, Word &dDay);
	bool __fastcall CheckSumOk(AnsiString strNMEA);
	void __fastcall ParseNMEA(AnsiString strNMEA);
	void __fastcall WriteLog(AnsiString str);
	Extended __fastcall FloatMod(Extended y, Extended x);
	AnsiString __fastcall ReplaceDecimalSeparator(AnsiString s);
	AnsiString __fastcall SafeCopy(AnsiString strText, int nStart, int nLength);
	bool __fastcall CompareFloats(Extended Value1, Extended Value2);
	int __fastcall CommasCount(AnsiString str);
	bool __fastcall RunningInTheIDE(void);
	void __fastcall DoRegistrationCheck(void);
	
protected:
	Classes::TNotifyEvent FOnReceive;
	TPositionChangeEvent FOnLatitudeChange;
	TPositionChangeEvent FOnLongitudeChange;
	TParamChangeEvent FOnAltitudeChange;
	TParamChangeEvent FOnSpeedChange;
	TParamChangeEvent FOnHeadingChange;
	TShortPositionChangeEvent FOn2DPositionChange;
	TShortPosition3DChangeEvent FOn3DPositionChange;
	TSatelliteReceiveEvent FOnSatelliteReceive;
	Classes::TNotifyEvent FOnSatellitesReceive;
	TArrivalEvent FOnArrival;
	__property bool ForceCheckSum = {read=FForceCheckSum, write=FForceCheckSum, default=1};
	__property bool NMEALog = {read=FNMEALog, write=FNMEALog, default=0};
	__property TNMEACommands Commands = {read=FCommands, write=FCommands, nodefault};
	__property Classes::TNotifyEvent OnReceive = {read=FOnReceive, write=FOnReceive};
	__property TPositionChangeEvent OnLatitudeChange = {read=FOnLatitudeChange, write=FOnLatitudeChange};
	__property TPositionChangeEvent OnLongitudeChange = {read=FOnLongitudeChange, write=FOnLongitudeChange};
	__property TParamChangeEvent OnAltitudeChange = {read=FOnAltitudeChange, write=FOnAltitudeChange};
	__property TParamChangeEvent OnSpeedChange = {read=FOnSpeedChange, write=FOnSpeedChange};
	__property TParamChangeEvent OnHeadingChange = {read=FOnHeadingChange, write=FOnHeadingChange};
	__property TShortPositionChangeEvent OnPosition2DChange = {read=FOn2DPositionChange, write=FOn2DPositionChange};
	__property TShortPosition3DChangeEvent OnPosition3DChange = {read=FOn3DPositionChange, write=FOn3DPositionChange};
	__property TSatelliteReceiveEvent OnSatelliteReceive = {read=FOnSatelliteReceive, write=FOnSatelliteReceive};
	__property Classes::TNotifyEvent OnSatellitesReceive = {read=FOnSatellitesReceive, write=FOnSatellitesReceive};
	__property TArrivalEvent OnArrival = {read=FOnArrival, write=FOnArrival};
	int __fastcall GetNMEACheckSum(AnsiString str);
	
public:
	__property double Version = {read=FVersion};
	__fastcall virtual TZylCustomGPSReceiver(Classes::TComponent* AOwner);
	__fastcall virtual ~TZylCustomGPSReceiver(void);
	void __fastcall FeedGPSReceiver(AnsiString strNMEA);
	TGPSPosition* __fastcall GetPosition(void);
	Extended __fastcall GetLatitudeAsDecimalDegrees(void);
	Extended __fastcall GetLongitudeAsDecimalDegrees(void);
	Extended __fastcall GetLatitudeAsRadians(void);
	Extended __fastcall GetLongitudeAsRadians(void);
	void __fastcall GetLatitudeParams(int &Degree, int &Minute, Extended &Second, TCardinalPoint &Direction);
	void __fastcall GetLongitudeParams(int &Degree, int &Minute, Extended &Second, TCardinalPoint &Direction);
	int __fastcall GetLatitudeDegree(void);
	int __fastcall GetLatitudeMinute(void);
	Extended __fastcall GetLatitudeSecond(void);
	TCardinalPoint __fastcall GetLatitudeDirection(void);
	int __fastcall GetLongitudeDegree(void);
	int __fastcall GetLongitudeMinute(void);
	Extended __fastcall GetLongitudeSecond(void);
	TCardinalPoint __fastcall GetLongitudeDirection(void);
	int __fastcall GetSatelliteCount(void);
	Classes::TList* __fastcall GetSatellites(void);
	TCardinalPoint __fastcall GetDeclination(void);
	Extended __fastcall GetAltitude(void);
	Extended __fastcall GetSpeed_KMH(void);
	Extended __fastcall GetSpeed_Knots(void);
	Extended __fastcall GetHeading(void);
	System::TDateTime __fastcall GetUTCDateTime(void);
	System::TDateTime __fastcall GetLocalDateTime(void);
	Extended __fastcall GetMagnetic_Variation(void);
	Extended __fastcall GetMagnetic_Heading(void);
	Extended __fastcall GetPDOP(void);
	Extended __fastcall GetHDOP(void);
	Extended __fastcall GetVDOP(void);
	Extended __fastcall GetGeo_Height(void);
	AnsiString __fastcall GetRawData();
	Word __fastcall IsFix(void);
	Word __fastcall GetMode1(void);
	Word __fastcall GetMode2(void);
	TReceiverStatus* __fastcall GetReceiverStatus(void);
	TNavigationInfo* __fastcall GetNavigationInfo(void);
	Extended __fastcall KmhToKnots(Extended pSpeed);
	Extended __fastcall KnotsToKmh(Extended pSpeed);
	Extended __fastcall KmToMiles(Extended pDist);
	Extended __fastcall MilesToKm(Extended pDist);
	Extended __fastcall NauticalMilesToKm(Extended pDist);
	Extended __fastcall KmToNauticalMiles(Extended pDist);
	Extended __fastcall DMSToDecimalDegrees(int Degree, int Minute, Extended Second, TCardinalPoint Direction);
	Extended __fastcall DMSToRadians(int Degree, int Minute, Extended Second, TCardinalPoint Direction);
	Extended __fastcall DecimalDegreesToRadians(Extended Degree);
	Extended __fastcall RadiansToDecimalDegrees(Extended Radian);
	void __fastcall LatitudeDecimalDegreesToDMS(Extended DecDegree, int &Degree, int &Minute, Extended &Second, TCardinalPoint &Direction);
	void __fastcall LatitudeRadiansToDMS(Extended Radian, int &Degree, int &Minute, Extended &Second, TCardinalPoint &Direction);
	void __fastcall LongitudeDecimalDegreesToDMS(Extended DecDegree, int &Degree, int &Minute, Extended &Second, TCardinalPoint &Direction);
	void __fastcall LongitudeRadiansToDMS(Extended Radian, int &Degree, int &Minute, Extended &Second, TCardinalPoint &Direction);
	Extended __fastcall Distance_KM(int Latitude_Degree1, int Latitude_Minute1, Extended Latitude_Second1, TCardinalPoint Latitude_Direction1, int Longitude_Degree1, int Longitude_Minute1, Extended Longitude_Second1, TCardinalPoint Longitude_Direction1, int Latitude_Degree2, int Latitude_Minute2, Extended Latitude_Second2, TCardinalPoint Latitude_Direction2, int Longitude_Degree2, int Longitude_Minute2, Extended Longitude_Second2, TCardinalPoint Longitude_Direction2)/* overload */;
	Extended __fastcall Distance_KM(Extended Latitude1, Extended Longitude1, Extended Latitude2, Extended Longitude2)/* overload */;
	Extended __fastcall DistanceTo_KM(int Latitude_Degree, int Latitude_Minute, Extended Latitude_Second, TCardinalPoint Latitude_Direction, int Longitude_Degree, int Longitude_Minute, Extended Longitude_Second, TCardinalPoint Longitude_Direction)/* overload */;
	Extended __fastcall DistanceTo_KM(Extended Latitude, Extended Longitude)/* overload */;
	Extended __fastcall Distance_Miles(int Latitude_Degree1, int Latitude_Minute1, Extended Latitude_Second1, TCardinalPoint Latitude_Direction1, int Longitude_Degree1, int Longitude_Minute1, Extended Longitude_Second1, TCardinalPoint Longitude_Direction1, int Latitude_Degree2, int Latitude_Minute2, Extended Latitude_Second2, TCardinalPoint Latitude_Direction2, int Longitude_Degree2, int Longitude_Minute2, Extended Longitude_Second2, TCardinalPoint Longitude_Direction2)/* overload */;
	Extended __fastcall Distance_Miles(Extended Latitude1, Extended Longitude1, Extended Latitude2, Extended Longitude2)/* overload */;
	Extended __fastcall DistanceTo_Miles(int Latitude_Degree, int Latitude_Minute, Extended Latitude_Second, TCardinalPoint Latitude_Direction, int Longitude_Degree, int Longitude_Minute, Extended Longitude_Second, TCardinalPoint Longitude_Direction)/* overload */;
	Extended __fastcall DistanceTo_Miles(Extended Latitude, Extended Longitude)/* overload */;
	Extended __fastcall Bearing(int Latitude_Degree1, int Latitude_Minute1, Extended Latitude_Second1, TCardinalPoint Latitude_Direction1, int Longitude_Degree1, int Longitude_Minute1, Extended Longitude_Second1, TCardinalPoint Longitude_Direction1, int Latitude_Degree2, int Latitude_Minute2, Extended Latitude_Second2, TCardinalPoint Latitude_Direction2, int Longitude_Degree2, int Longitude_Minute2, Extended Longitude_Second2, TCardinalPoint Longitude_Direction2)/* overload */;
	Extended __fastcall Bearing(Extended Latitude1, Extended Longitude1, Extended Latitude2, Extended Longitude2)/* overload */;
	Extended __fastcall BearingTo(int Latitude_Degree, int Latitude_Minute, Extended Latitude_Second, TCardinalPoint Latitude_Direction, int Longitude_Degree, int Longitude_Minute, Extended Longitude_Second, TCardinalPoint Longitude_Direction)/* overload */;
	Extended __fastcall BearingTo(Extended Latitude, Extended Longitude)/* overload */;
};


//-- var, const, procedure ---------------------------------------------------
#define RADIUS_EARTH  (6.378140E+03)

}	/* namespace Zylcustomgpsreceiver */
using namespace Zylcustomgpsreceiver;
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// ZylCustomGPSReceiver
